// GetAllNoteFields.cpp : implementation file
//

#include "stdafx.h"
#include "db_apivcclient.h"
#include "GetAllNoteFields.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGetAllNoteFields dialog


CGetAllNoteFields::CGetAllNoteFields(CWnd* pParent /*=NULL*/)
	: CDialog(CGetAllNoteFields::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGetAllNoteFields)
	// WPACT-5808 : Kalpesh
	//m_sNFDefinition.SetWindowText(L"");
	//}}AFX_DATA_INIT
}

CGetAllNoteFields::CGetAllNoteFields(IApplication *pApp, CWnd* pParent /*=NULL*/)
: CDialog(CGetAllNoteFields::IDD, pParent)
{
	pApplication = pApp;
	// WPACT-5808 : Kalpesh
	//m_sNFDefinition.SetWindowText(L"");
}


void CGetAllNoteFields::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGetAllNoteFields)
	DDX_Control(pDX, IDC_NFLIST_NF, m_NFList);
	DDX_Control(pDX, IDC_ACCTLIST_NF, m_AcctList);
	DDX_Control(pDX, IDC_SUBACCTLIST_NF, m_SubAcctList);	
	DDX_Control(pDX, IDC_EDIT_NFTEMPLATE, m_sNFDefinition);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGetAllNoteFields, CDialog)
	//{{AFX_MSG_MAP(CGetAllNoteFields)
	ON_WM_CLOSE()
	ON_CBN_SELCHANGE(IDC_ACCTLIST_NF, OnSelchangeAcctlist)
	ON_CBN_SELCHANGE(IDC_SUBACCTLIST_NF, OnSelchangeSubAcctlist)
	ON_CBN_SELCHANGE(IDC_NFLIST_NF, OnSelchangeNFlist)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGetAllNoteFields message handlers

BOOL CGetAllNoteFields::OnInitDialog() 
{
	CDialog::OnInitDialog();
	// WPACT-5808 : Kalpesh
	m_sNFDefinition.SetWindowText(L"");

	LoadAccounts();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CGetAllNoteFields::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	
	CDialog::OnClose();
}

void CGetAllNoteFields::OnSelchangeAcctlist() 
{
	m_NFList.ResetContent();
	m_SubAcctList.ResetContent();
	LoadSubAccounts();
}

void CGetAllNoteFields::OnSelchangeSubAcctlist() 
{
	m_NFList.ResetContent();
	LoadNoteFields();
}

void CGetAllNoteFields::OnSelchangeNFlist() 
{
	m_sNFDefinition.SetWindowText(L"");
	UpdateData(FALSE);

	int idx_NFName = m_NFList.GetCurSel();
	CString sNFName;
	if(idx_NFName < 0)
		return;
	m_NFList.GetLBText(idx_NFName, sNFName);

	long uBound = 0;
	INoteField *pNoteField = NULL;
	COleSafeArray sa(m_vNotefields);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	for(long i =0 ;i <= uBound ; i++)
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_INoteField,(void**)&pNoteField);
		if (pNoteField != NULL && sNFName == CString((LPCSTR)pNoteField->NoteFieldName))
		{
			m_sNFDefinition.SetWindowText(CString((LPCSTR)pNoteField->FieldDefinition));
			break;
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
}

void CGetAllNoteFields::LoadAccounts()
{
	_variant_t vAccounts;
	vAccounts.Clear();
	pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
	
	if(vAccounts.vt ==  VT_EMPTY)
	{
		return;
	}
	
	long uBound =0 ;
	IAccount *pAccount = NULL;
	
	COleSafeArray sa(vAccounts);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	for(long i =0 ;i <= uBound ; i++)
		
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
		if (pAccount != NULL)
		{
			m_AcctList.SetItemData(m_AcctList.AddString(pAccount->AccountName),pAccount->AccountID);
			pAccount->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
}

void CGetAllNoteFields :: LoadSubAccounts()
{
		_variant_t vSubAccounts;
		vSubAccounts.Clear();
				
		//select AccountID
		int index_Acct = m_AcctList.GetCurSel();		
		long lAccountID = m_AcctList.GetItemData(index_Acct);	

		if(lAccountID <= 0)
		{
			AfxMessageBox(L"Select Account!");
			return;
		}
		pApplication->GetSubAccountsByAccountID(lAccountID, &vSubAccounts); // get account details in WP-CS database server
		
		if(vSubAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0, lBound ;
		IAccount *pSubAccount= NULL;
		
		COleSafeArray sa(vSubAccounts);
		sa.GetUBound(1,&uBound);
		sa.GetLBound(1,&lBound);
		UpdateData(TRUE);
		for(long i =lBound ;i <= uBound ; i++)		
		{			
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pSubAccount);
			if (pSubAccount!= NULL)
			{				
				m_SubAcctList.SetItemData(m_SubAcctList.AddString(pSubAccount->AccountName), pSubAccount->AccountID);
				pSubAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	
	//m_AccountList.SetCurSel(0);
	
}


void CGetAllNoteFields::LoadNoteFields()
{
	m_vNotefields.vt = VT_EMPTY;
	CString sAcctName;
	int idx_Acct = m_AcctList.GetCurSel();
	if(idx_Acct < 0)
		return;
	m_AcctList.GetLBText(idx_Acct, sAcctName);

	BSTR bstrAcctName = sAcctName.AllocSysString();

	//select Sub account name 
	BSTR bstrSubAcctName;
		int index_SubAccount = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		if (index_SubAccount <0)
			bstrSubAcctName = SysAllocString(L"");
		else
		{
			m_SubAcctList.GetLBText(index_SubAccount,sSubAcctName);
			bstrSubAcctName = sSubAcctName.AllocSysString();
		}
		

	pApplication->GetNoteFieldTemplateDetailsByAccount(bstrAcctName, bstrSubAcctName, &m_vNotefields);

	if(m_vNotefields.vt == VT_EMPTY)
	{
		AfxMessageBox(_T("No NoteField Templates"));
		return;
	}

	long uBound =0 ;
	INoteField *pNoteField = NULL;
	
	COleSafeArray sa(m_vNotefields);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	for(long i =0 ;i <= uBound ; i++)
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_INoteField,(void**)&pNoteField);
		if (pNoteField != NULL)
		{
			m_NFList.AddString(pNoteField->NoteFieldName);
			pNoteField->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
}